#!/usr/local/bin/perl

unshift(@INC,"$ENV{'DOCUMENT_ROOT'}/msql_keeper/cgi/");
use lib "$ENV{'DOCUMENT_ROOT'}/msql_keeper/lib";
use myXBase;
use Msql;

require ("mk_config.cgi");
require ("mk_lib.cgi");
require ("mk_fields.cgi");
require ("mk_table.cgi");
require ("mk_db.cgi");
require ("mk_impexp.cgi");

print "Content-type\: text/html\n\n";
&ReadParse;

if ($Msql::VERSION < 1.03) {
	&print_error("	<b>mSQL Keeper needs Msql.pm version 1.03 or later.<br></b>
					You are currently using Version $Msql::VERSION <br>
					Get the latest version from <a href = \"ftp://Bond.edu.au/pub/Minerva/msql/Contrib/mSQLPerl/\">ftp://Bond.edu.au/pub/Minerva/msql/Contrib/mSQLPerl/</a>&nbsp;NOW.
					
				");
}

$table = $in{'table'};
$new_table_name = $in{'new_table_name'};

if ($in{'action'} eq "select_db") {&select_db; exit;}
if (not &get_database) {&print_error("Could not get database!<br> Please check that file $database_file exists, has read/write permissions, and that the first line of the file reads \"database=your_database_name\""); exit;}
if (not ($dbh = Msql->Connect("",$database))) {&print_error("Could Not Connect to Database! Reason: ".$Msql::db_errstr);exit;}

if (scalar(%in)) {	
	if ($in{'action'}) {
		
		$this_action = $in{'action'}; 
		if ($this_action eq "from_text") {
			&get_file;
		
		} elsif ($this_action eq "query_table") {		
			&query_table;

		} elsif ($this_action eq "query_table_final") {
			&query_table_results;

		} elsif ($this_action eq "to_ansi_sql") {
			&to_ansi_sql;
		
		} elsif ($this_action eq "naming_conventions") {
			&naming_conventions;

		} elsif ($this_action eq "from_text_final") {
			&from_text;
		
		} elsif ($this_action eq "mod_fields") {
			&mod_fields;
		
		} elsif ($this_action eq "mod_fields_final") {
			&mod_fields_final;
		
		} elsif ($this_action eq "to_text") {
			&get_separator("Export To Text File");
		
		} elsif ($this_action eq "to_text_final") {
			&to_text;
		
		} elsif ($this_action eq "restore_db") {
			&restore_db;
		
		} elsif ($this_action eq "restore_db_final") {
			&restore_db;
		
		} elsif ($this_action eq "dump_database") {
			&dump_database;
		
		} elsif ($this_action eq "add_data_final") {
			&add_row;
		
		} elsif ($this_action eq "add_data") {
			&add_data;
		
		} elsif ($this_action eq "create_table_final") {
			&create_table;
		
		} elsif ($this_action eq "view_info") {
			&print_structure ($table, 0, 0, 0, 0, 1);
		
		} elsif ($this_action eq "create_table") {
			&print_structure ("", 0, 0, 1);
		
		} elsif ($this_action eq "backup_table") {
			&change_name;
		
		} elsif ($this_action eq "change_name") {
			&change_name("DROP_TABLE");
		
		} elsif ($this_action eq "add_fields") {
			&print_structure ($table, 0, 1);
		
		} elsif ($this_action eq "remove_fields") {
			&print_structure ($table, 1);
		
		} elsif ($this_action eq "add_fields_final") {
			&add_field;
		
		} elsif ($this_action eq "remove_fields_final") {
			&remove_field;
		
		} elsif ($this_action eq "mod_field") {
			&mod_field;
		
		} elsif ($this_action eq "drop_table") {
			&drop_table($table);
		
		} elsif ($this_action eq "from_x_base") {
			&get_file;

		} elsif ($this_action eq "from_x_base_final") {
			&from_x_base;

		} elsif ($this_action eq "select_db") {
			&select_db;

		} else {
			&print_error("This feature is Under Construction.");
		}

	} else {
		&print_error("<b>Nothing To Do!!</b>");
	}

} else {

	&print_error("<b>Unrecognized Action!!</b>");
}

sub naming_conventions {
	
	print &html("miniSQL Naming Conventions");
	print "<center><h2>miniSQL Naming Conventions</center></h2>$valid_names_text<p>";
	print &html_bot;
	return 1;
}

sub select_db {
	my $file_open = 1;
	print &html;
	unlink $database_file;
	open (DATABASE, ">>$database_file") or $file_open = 0;
	
	if ($file_open) {
		print DATABASE "database=$in{'db'}\n";
		close DATABASE;
		print "Database was changed to <b>$in{'db'}</b><br>";
	} else {
		print "Can't open file <b>$database_file</b>.<br> Reason: $!<br>";
	}
	
	
	print "<a href=\"/msql_keeper/index.shtml\">Return to mSQL Keeper Main</a>";
	print "</body></html>";
	return 1;

}
exit;
1;